import type { BranchContext } from '../BranchRoot';
import { useBranch } from '../useBranch';

/**
 * Provides the {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-deepview-cta deepviewCta} function to trigger the install flow from a deepview.
 *
 * @returns {BranchContext['branch']['deepviewCta']} deepviewCta function (call this on user action)
 */
export function useDeepviewCta(): BranchContext['branch']['deepviewCta'] {
  const { branch } = useBranch();

  return branch.deepviewCta.bind(branch);
}
