import { act, renderHook } from '@testing-library/react-hooks';
import branchSDK from 'branch-sdk';
import { useDeepviewCta } from '.';

jest.mock('branch-sdk');

describe(useDeepviewCta, () => {
  afterEach(() => {
    jest.resetAllMocks();
  });
  it('should not call branch.deepviewCta() on render', () => {
    const { result } = renderHook(() => useDeepviewCta());

    expect(result.current).toStrictEqual(expect.any(Function));
    expect(branchSDK.deepviewCta).not.toHaveBeenCalled();
  });

  it('calls branch.deepviewCta() on on upon calling it', () => {
    const { result } = renderHook(() => useDeepviewCta());

    expect(result.current).toStrictEqual(expect.any(Function));
    expect(branchSDK.deepviewCta).not.toHaveBeenCalled();

    act(() => {
      result.current();
    });

    expect(branchSDK.deepviewCta).toHaveBeenCalled();
  });
});
