import type { DeepLinkData } from 'branch-sdk';
import useDeepCompareEffect from 'use-deep-compare-effect';
import { useBranch } from '../useBranch';

/**
 * Use this to set dynamic data for journeys on the current page. {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-set-branch-view-data-data Learn more}
 *
 * @param {DeepLinkData} viewData The viewdata for journeys on the page.
 */
export function useJourneyViewData(viewData: DeepLinkData): void {
  const { branch } = useBranch();

  useDeepCompareEffect(() => {
    // the new object here is necessary because branch mutates the viewData.data object when we call branch.setBranchViewData() which would otherwise cause the deepEffect to re-trigger
    const clonedViewData = {
      ...viewData,
      data: { ...viewData.data },
    };
    branch.setBranchViewData(clonedViewData);
  }, [branch, viewData]);
}
