import { renderHook } from '@testing-library/react-hooks';
import branchSDK from 'branch-sdk';
import { generateDeepLinkData } from '../test-utils';
import { useJourneyViewData } from '.';

jest.mock('branch-sdk');

describe(useJourneyViewData, () => {
  const defaultJourneyViewData = generateDeepLinkData();

  afterEach(() => {
    jest.resetAllMocks();
  });

  it('calls branch.setBranchViewData() with the expected deepview data', () => {
    renderHook((props) => useJourneyViewData(props), {
      initialProps: defaultJourneyViewData,
    });

    expect(branchSDK.setBranchViewData).toHaveBeenCalledWith(
      defaultJourneyViewData,
    );
  });

  it('does not call branch.setBranchViewData() again if values have not changed (deep compare)', () => {
    expect(branchSDK.setBranchViewData).toHaveBeenCalledTimes(0);

    const { rerender } = renderHook((props) => useJourneyViewData(props), {
      initialProps: defaultJourneyViewData,
    });

    expect(branchSDK.setBranchViewData).toHaveBeenCalledTimes(1);
    expect(branchSDK.setBranchViewData).toHaveBeenCalledWith(
      defaultJourneyViewData,
    );

    // re-render  with the same data, but a new object
    rerender({ ...defaultJourneyViewData });

    expect(branchSDK.setBranchViewData).toHaveBeenCalledTimes(1);

    // change a nested key, we now re-render the effect
    const changedJourneyViewData = {
      ...defaultJourneyViewData,
      data: { ...defaultJourneyViewData.data, customKey: 'has_changed' },
    };
    rerender(changedJourneyViewData);

    expect(branchSDK.setBranchViewData).toHaveBeenCalledTimes(2);
    expect(branchSDK.setBranchViewData).toHaveBeenCalledWith(
      changedJourneyViewData,
    );
  });
});
