import type { BranchContext } from '../BranchRoot';
import { useBranch } from '../useBranch';

interface UseLoggingReturn {
  disableTracking: BranchContext['branch']['disableTracking'];
  logEvent: BranchContext['branch']['logEvent'];
}

/**
 * Convenience hook to access {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-log-event-event-event-data-and-custom-data-content-items-customer-event-alias-callback branch.logEvent()} and {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-disable-tracking-disable-tracking branch.disableTracking()}.
 *
 * @returns {UseLoggingReturn} Object of `{ disableTracking, logEvent }`
 */
export function useLogging(): UseLoggingReturn {
  const { branch } = useBranch();

  return {
    disableTracking: branch.disableTracking.bind(branch),
    logEvent: branch.logEvent.bind(branch),
  };
}
