import { act, renderHook } from '@testing-library/react-hooks';
import branchSDK from 'branch-sdk';
import { useLogging } from '.';

jest.mock('branch-sdk');

describe(useLogging, () => {
  afterEach(() => {
    jest.resetAllMocks();
  });
  it('provides branch.disableTracking() and branch.logEvent() functions', () => {
    const { result } = renderHook(() => useLogging());

    expect(result.current).toMatchObject({
      disableTracking: expect.any(Function),
      logEvent: expect.any(Function),
    });
  });

  it('should let us call branch.disableTracking()', () => {
    const { result } = renderHook(() => useLogging());
    expect(branchSDK.disableTracking).not.toHaveBeenCalled();
    act(() => {
      result.current.disableTracking();
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(1);
    act(() => {
      result.current.disableTracking(false);
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(2);
    expect(branchSDK.disableTracking).toHaveBeenCalledWith(false);
    act(() => {
      result.current.disableTracking(true);
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(3);
    expect(branchSDK.disableTracking).toHaveBeenCalledWith(true);
  });

  it('should let us call branch.logEvent()', () => {
    const event_name = 'test-event';
    const event_data = { foo: 'bar' };

    const { result } = renderHook(() => useLogging());
    expect(branchSDK.logEvent).not.toHaveBeenCalled();
    act(() => {
      result.current.logEvent(event_name, event_data);
    });
    expect(branchSDK.logEvent).toHaveBeenCalledTimes(1);
    expect(branchSDK.logEvent).toHaveBeenLastCalledWith(event_name, event_data);
  });
});
