import type { BranchContext } from '../BranchRoot';
import { useBranch } from '../useBranch';

interface UseTrackingReturn {
  disableTracking: BranchContext['branch']['disableTracking'];
  track: BranchContext['branch']['track'];
  trackCommerceEvent: BranchContext['branch']['trackCommerceEvent'];
}
/**
 * * Convenience hook to access {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-track-event-metadata-callback branch.track()}, {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-track-commerce-event-event-commerce-data-metadata-callback branch.trackCommerceEvent()} and {@link https://help.branch.io/developers-hub/docs/web-full-reference#section-disable-tracking-disable-tracking branch.disableTracking()}.
 *
 * @returns {UseTrackingReturn} Object of `{ disableTracking, track, trackCommerceEvent }`
 */
export function useTracking(): UseTrackingReturn {
  const { branch } = useBranch();

  return {
    disableTracking: (...args) => branch.disableTracking(...args),
    track: (...args) => branch.track(...args),
    trackCommerceEvent: (...args) => branch.trackCommerceEvent(...args),
  };
}
