import { act, renderHook } from '@testing-library/react-hooks';
import branchSDK from 'branch-sdk';
import { useTracking } from '.';

jest.mock('branch-sdk');

describe(useTracking, () => {
  afterEach(() => {
    jest.resetAllMocks();
  });

  it('provides branch.disableTracking() and branch.logEvent() functions', () => {
    const { result } = renderHook(() => useTracking());

    expect(result.current).toMatchObject({
      disableTracking: expect.any(Function),
      track: expect.any(Function),
      trackCommerceEvent: expect.any(Function),
    });
  });

  it('provides a callback for branch.disableTracking()', () => {
    const { result } = renderHook(() => useTracking());
    expect(branchSDK.disableTracking).not.toHaveBeenCalled();
    act(() => {
      result.current.disableTracking();
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(1);
    act(() => {
      result.current.disableTracking(false);
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(2);
    expect(branchSDK.disableTracking).toHaveBeenCalledWith(false);
    act(() => {
      result.current.disableTracking(true);
    });
    expect(branchSDK.disableTracking).toHaveBeenCalledTimes(3);
    expect(branchSDK.disableTracking).toHaveBeenCalledWith(true);
  });

  it('provides a callback for branch.track()', () => {
    const eventName = 'test-event';
    const eventData = { foo: 'bar' };

    const { result } = renderHook(() => useTracking());
    expect(branchSDK.track).not.toHaveBeenCalled();
    act(() => {
      result.current.track(eventName, eventData);
    });
    expect(branchSDK.track).toHaveBeenCalledTimes(1);
    expect(branchSDK.track).toHaveBeenLastCalledWith(eventName, eventData);
  });

  it('provides a callback for branch.trackCommerceEvent()', () => {
    const eventName = 'purchase';
    const eventData = { foo: 'bar' };

    const { result } = renderHook(() => useTracking());
    expect(branchSDK.trackCommerceEvent).not.toHaveBeenCalled();
    act(() => {
      result.current.trackCommerceEvent(eventName, eventData);
    });
    expect(branchSDK.trackCommerceEvent).toHaveBeenCalledTimes(1);
    expect(branchSDK.trackCommerceEvent).toHaveBeenLastCalledWith(
      eventName,
      eventData,
    );
  });
});
