import type {
  BlockingListeners,
  GamepadEventName,
  Listeners,
} from '../../types';

export type FireEventOpts = {
  blockingListeners: BlockingListeners;
  eventName: GamepadEventName;
  gamepadIndex: number;
  listeners: Listeners;
  value?: number;
};

export function fireEvent({
  blockingListeners,
  eventName,
  gamepadIndex,
  listeners,
  value,
}: FireEventOpts): void {
  const blockingCallback = blockingListeners[eventName];
  if (blockingCallback) {
    blockingCallback(gamepadIndex, value);
    return;
  }

  listeners?.[eventName]?.forEach((callback) => {
    callback(gamepadIndex, value);
  });
}
