import { GamepadAxis, GamepadButton } from './types';

// Order of these arrays are designed to line up with the default mapping defined
// in the standard: https://w3c.github.io/gamepad/#dfn-standard-gamepad-layout
// It's possible in the future that we may need to support different mappings
// if we encounter a console that doesn't use this mapping.
export const GAMEPAD_BUTTONS = [
  GamepadButton.FaceButtonDown,
  GamepadButton.FaceButtonRight,
  GamepadButton.FaceButtonLeft,
  GamepadButton.FaceButtonUp,
  GamepadButton.L1,
  GamepadButton.R1,
  GamepadButton.L2,
  GamepadButton.R2,
  GamepadButton.Select,
  GamepadButton.Start,
  GamepadButton.L3,
  GamepadButton.R3,
  GamepadButton.DpadUp,
  GamepadButton.DpadDown,
  GamepadButton.DpadLeft,
  GamepadButton.DpadRight,
];

export const GAMEPAD_AXES = [
  GamepadAxis.LeftStickHorizontal,
  GamepadAxis.LeftStickVertical,
  GamepadAxis.RightStickHorizontal,
  GamepadAxis.RightStickVertical,
];
