import { GAMEPAD_BUTTONS } from './constants';

const unpressedButton: globalThis.GamepadButton = {
  pressed: false,
  touched: false,
  value: 0,
};
const pressedButton: globalThis.GamepadButton = {
  pressed: true,
  touched: false,
  value: 0,
};

function getMockButtons(
  pressedButtons: number[],
): Array<globalThis.GamepadButton> {
  const emptyArray = new Array(GAMEPAD_BUTTONS.length).fill(unpressedButton);
  return emptyArray.map((button, index) => {
    if (pressedButtons.find((val) => val === index)) {
      return pressedButton;
    }
    return button;
  });
}

export function getMockGamepad(
  index: number,
  pressedButtons: number[],
  axes: number[] = [],
): Gamepad {
  return {
    axes,
    buttons: getMockButtons(pressedButtons),
    connected: true,
    hapticActuators: [],
    id: '',
    index,
    mapping: 'standard',
    timestamp: 0,
  };
}
