import {
  ROOT_FOCUS_ID,
  childFocusIndexForFocusedArea,
  focusIdContainsElement,
  getFocusId,
  splitFocusId,
} from '.';

describe(getFocusId, () => {
  it.each`
    parentFocusId | focusIndex | focusId
    ${'0'}        | ${0}       | ${'0.0'}
    ${'0.0'}      | ${0}       | ${'0.0.0'}
    ${'0.1'}      | ${0}       | ${'0.1.0'}
    ${'0.0'}      | ${1}       | ${'0.0.1'}
    ${'0.10'}     | ${1}       | ${'0.10.1'}
    ${'0.1'}      | ${10}      | ${'0.1.10'}
  `(
    'returns $focusId for $parentFocusId and $focusIdx',
    ({ focusId, focusIndex, parentFocusId }) => {
      expect(getFocusId(parentFocusId, focusIndex)).toEqual(focusId);
    },
  );
});

describe(focusIdContainsElement, () => {
  it.each`
    focusId     | elementId  | focused
    ${'0'}      | ${'0'}     | ${true}
    ${'0'}      | ${'1'}     | ${false}
    ${'0.0'}    | ${'0'}     | ${true}
    ${'0.0'}    | ${'1'}     | ${false}
    ${'0.0'}    | ${'0.0'}   | ${true}
    ${'0.0'}    | ${'0.1'}   | ${false}
    ${'0.10'}   | ${'0.1'}   | ${false}
    ${'0.0.0'}  | ${'0.0'}   | ${true}
    ${'0.0.10'} | ${'0.0'}   | ${true}
    ${'0.0.0'}  | ${'0.1.0'} | ${false}
    ${'0.0.0'}  | ${'0.0.1'} | ${false}
  `(
    'returns $focused for $focusId and $elementId',
    ({ elementId, focusId, focused }) => {
      expect(focusIdContainsElement({ elementId, focusId })).toEqual(focused);
    },
  );
});

describe(childFocusIndexForFocusedArea, () => {
  it.each`
    focusId       | areaFocusId | childFocusIndex
    ${'0.0.0'}    | ${'0.0'}    | ${0}
    ${'0.0.0.0'}  | ${'0.0'}    | ${0}
    ${'0.0.1.0'}  | ${'0.0'}    | ${1}
    ${'0.0.10.0'} | ${'0.0'}    | ${10}
  `(
    '$focusId returns $childFocusIndex for area: $areaFocusId',
    ({ areaFocusId, childFocusIndex, focusId }) => {
      expect(childFocusIndexForFocusedArea(focusId, areaFocusId)).toEqual(
        childFocusIndex,
      );
    },
  );

  it('throws when attempting to request a childFocusIndex for a non-focused parent ID', () => {
    expect(() => childFocusIndexForFocusedArea('0.0.0', '0.1')).toThrow();
  });

  it('throws when attempting to request a childFocusIndex for a focused leaf', () => {
    expect(() => childFocusIndexForFocusedArea('0.0.0', '0.0.0')).toThrow();
  });
});

describe(splitFocusId, () => {
  it.each`
    focusId                      | parentFocusId              | childFocusIndex
    ${ROOT_FOCUS_ID}             | ${ROOT_FOCUS_ID}           | ${0}
    ${`${ROOT_FOCUS_ID}.0`}      | ${`${ROOT_FOCUS_ID}`}      | ${0}
    ${`${ROOT_FOCUS_ID}.0.1`}    | ${`${ROOT_FOCUS_ID}.0`}    | ${1}
    ${`${ROOT_FOCUS_ID}.0.1`}    | ${`${ROOT_FOCUS_ID}.0`}    | ${1}
    ${`${ROOT_FOCUS_ID}.0.0.0`}  | ${`${ROOT_FOCUS_ID}.0.0`}  | ${0}
    ${`${ROOT_FOCUS_ID}.0.1.0`}  | ${`${ROOT_FOCUS_ID}.0.1`}  | ${0}
    ${`${ROOT_FOCUS_ID}.0.10.0`} | ${`${ROOT_FOCUS_ID}.0.10`} | ${0}
    ${`${ROOT_FOCUS_ID}.0.1.10`} | ${`${ROOT_FOCUS_ID}.0.1`}  | ${10}
  `(
    '$focusId returns parentFocusId: $parentFocusId and childFocusIndex:$childFocusIndex',
    ({ childFocusIndex, focusId, parentFocusId }) => {
      expect(splitFocusId(focusId)).toEqual({
        childFocusIndex: Number.parseInt(childFocusIndex),
        parentFocusId,
      });
    },
  );
});
