type GetIndexForPageNavOpts = {
  elementCount: number;
  focusIndex: number;
  pageSize: number;
};

export function getIndexForPageNext({
  elementCount,
  focusIndex,
  pageSize,
}: GetIndexForPageNavOpts): number {
  const currentPageNumber = Math.floor(focusIndex / pageSize);
  const currentPageLastIndex = (currentPageNumber + 1) * pageSize - 1;
  return Math.min(currentPageLastIndex + pageSize, elementCount - 1);
}

export function getIndexForPagePrev({
  elementCount,
  focusIndex,
  pageSize,
}: GetIndexForPageNavOpts): number {
  // we act like we're paginating forwards through the reverse of our list
  // to mirror proper scroll behavior
  const inverseIndex = getIndexForPageNext({
    elementCount,
    focusIndex: elementCount - 1 - focusIndex,
    pageSize,
  });
  return elementCount - 1 - inverseIndex;
}
