import { getIndexForPageNext, getIndexForPagePrev } from '.';

describe('getIndexForPageNav functions', () => {
  describe(getIndexForPageNext, () => {
    it('sets index to end of second page to move entire second page into view for all first page entries', () => {
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 0, pageSize: 3 }),
      ).toEqual(5);
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 1, pageSize: 3 }),
      ).toEqual(5);
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 2, pageSize: 3 }),
      ).toEqual(5);
    });

    it('sets index to end of third page to move entire third page into view for all second page entries', () => {
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 3, pageSize: 3 }),
      ).toEqual(8);
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 4, pageSize: 3 }),
      ).toEqual(8);
      expect(
        getIndexForPageNext({ elementCount: 12, focusIndex: 5, pageSize: 3 }),
      ).toEqual(8);
    });

    it('sets index to last element if moving to a non-full last page', () => {
      expect(
        getIndexForPageNext({ elementCount: 4, focusIndex: 0, pageSize: 3 }),
      ).toEqual(3);
      expect(
        getIndexForPageNext({ elementCount: 4, focusIndex: 1, pageSize: 3 }),
      ).toEqual(3);
      expect(
        getIndexForPageNext({ elementCount: 4, focusIndex: 2, pageSize: 3 }),
      ).toEqual(3);

      expect(
        getIndexForPageNext({ elementCount: 5, focusIndex: 0, pageSize: 3 }),
      ).toEqual(4);
      expect(
        getIndexForPageNext({ elementCount: 5, focusIndex: 1, pageSize: 3 }),
      ).toEqual(4);
      expect(
        getIndexForPageNext({ elementCount: 5, focusIndex: 2, pageSize: 3 }),
      ).toEqual(4);
    });
  });

  describe(getIndexForPagePrev, () => {
    it('sets index to start of first page to move entire first page into view for all second page entries', () => {
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 3, pageSize: 3 }),
      ).toEqual(0);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 4, pageSize: 3 }),
      ).toEqual(0);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 5, pageSize: 3 }),
      ).toEqual(0);
    });

    it('sets index to start of second page to move entire second page into view for all third page entries', () => {
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 6, pageSize: 3 }),
      ).toEqual(3);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 7, pageSize: 3 }),
      ).toEqual(3);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 8, pageSize: 3 }),
      ).toEqual(3);
    });

    it('sets index to 0 if move would take us below first page', () => {
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 0, pageSize: 3 }),
      ).toEqual(0);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 1, pageSize: 3 }),
      ).toEqual(0);
      expect(
        getIndexForPagePrev({ elementCount: 12, focusIndex: 2, pageSize: 3 }),
      ).toEqual(0);
    });

    it('sets index appropriately for moving within non-full list', () => {
      expect(
        getIndexForPagePrev({ elementCount: 4, focusIndex: 3, pageSize: 3 }),
      ).toEqual(0);

      expect(
        getIndexForPagePrev({ elementCount: 5, focusIndex: 3, pageSize: 3 }),
      ).toEqual(0);
      expect(
        getIndexForPagePrev({ elementCount: 5, focusIndex: 4, pageSize: 3 }),
      ).toEqual(0);
    });
  });
});
