import type { FC } from 'react';
import type { SetOptional } from 'type-fest';
import type { BaseNavProps } from '../BaseNav';
import { BaseNav } from '../BaseNav';

export type GridNavProps = Omit<
  SetOptional<BaseNavProps, 'debugLabel'>,
  'horizontalIncrement' | 'pageSize' | 'type' | 'verticalIncrement'
> & {
  elementsPerRow: number;
};

// istanbul ignore next: trivial
/**
 * Manages navigation focus between elements in a wrapping grid area based on
 * user input using up / down / left / right & optionally wheel interactions.
 *
 * This component can be recursively nested in other navigation areas, allowing
 * for navigation between parent, child, and sibling areas.
 */
export const GridNav: FC<GridNavProps> = ({
  debugLabel,
  elementsPerRow,
  ...props
}) => (
  <BaseNav
    debugLabel={`GridNav:${debugLabel || 'unknown'}`}
    horizontalIncrement={1}
    type="grid"
    verticalIncrement={elementsPerRow}
    {...props}
  />
);

GridNav.displayName = 'GridNav';
