import type { FC } from 'react';
import type { SetOptional } from 'type-fest';
import type { BaseNavProps } from '../BaseNav';
import { BaseNav } from '../BaseNav';

export type HorizontalNavProps = Omit<
  SetOptional<BaseNavProps, 'debugLabel'>,
  'handleWheel' | 'horizontalIncrement' | 'type' | 'verticalIncrement'
>;

// istanbul ignore next: trivial
/**
 * Manages navigation focus between elements in a horizontal area based on user
 * input using left / right interactions.
 *
 * This component can be recursively nested in other navigation areas, allowing
 * for navigation between parent, child, and sibling areas.
 */
export const HorizontalNav: FC<HorizontalNavProps> = ({
  debugLabel,
  elementCount,
  ...props
}) => (
  <BaseNav
    debugLabel={`HorizontalNav:${debugLabel || 'unknown'}`}
    elementCount={elementCount}
    handleWheel={false}
    horizontalIncrement={1}
    type="horizontal"
    verticalIncrement={elementCount}
    {...props}
  />
);

HorizontalNav.displayName = 'HorizontalNav';
