/* eslint-disable tachyon/no-single-child-directional-navs */
import type { FC } from 'react';
import type { SetOptional } from 'type-fest';
import type { BaseNavProps } from '../BaseNav';
import { BaseNav } from '../BaseNav';

export type NodeNavProps = Omit<
  SetOptional<BaseNavProps, 'debugLabel'>,
  | 'elementCount'
  | 'handleWheel'
  | 'horizontalIncrement'
  | 'initialChildFocusIndex'
  | 'pageSize'
  | 'type'
  | 'verticalIncrement'
  | 'virtualizable'
>;

// istanbul ignore next: trivial
/**
 * Manages navigation focus for a single child element.
 *
 * This component can be recursively nested in other navigation areas, allowing
 * for navigation between parent, child, and sibling areas.
 */
export const NodeNav: FC<NodeNavProps> = ({ debugLabel, ...props }) => (
  <BaseNav
    debugLabel={`NodeNav:${debugLabel || 'unknown'}`}
    elementCount={1}
    handleWheel={false}
    horizontalIncrement={1}
    type="node"
    verticalIncrement={1}
    {...props}
  />
);

NodeNav.displayName = 'NodeNav';
