import type { FC } from 'react';
import type { SetOptional } from 'type-fest';
import type { BaseNavProps } from '../BaseNav';
import { BaseNav } from '../BaseNav';

export type VerticalNavProps = Omit<
  SetOptional<BaseNavProps, 'debugLabel' | 'handleWheel'>,
  'horizontalIncrement' | 'pageSize' | 'type' | 'verticalIncrement'
>;

// istanbul ignore next: trivial
/**
 * Manages navigation focus between elements in a vertical area based on user
 * input using up / down & optionally wheel interactions.
 *
 * This component can be recursively nested in other navigation areas, allowing
 * for navigation between parent, child, and sibling areas.
 */
export const VerticalNav: FC<VerticalNavProps> = ({
  debugLabel,
  elementCount,
  handleWheel = false,
  ...props
}) => (
  <BaseNav
    debugLabel={`VerticalNav:${debugLabel || 'unknown'}`}
    elementCount={elementCount}
    handleWheel={handleWheel}
    horizontalIncrement={elementCount}
    type="vertical"
    verticalIncrement={1}
    {...props}
  />
);

VerticalNav.displayName = 'VerticalNav';
