import { act, renderHook } from '@testing-library/react-hooks';
import type { FC } from 'react';
import { ROOT_FOCUS_ID, navigationContext } from '../../NavigationRoot';
import { mockFocusBroadcaster } from '../../test-mocks';
import { useAreaChildFocusIndex } from '.';

describe(useAreaChildFocusIndex, () => {
  function setup() {
    const broadcaster = mockFocusBroadcaster();

    const provider: FC = ({ children }) => (
      <navigationContext.Provider
        children={children}
        value={{
          broadcaster,
          parentFocusId: ROOT_FOCUS_ID,
        }}
      />
    );

    return {
      broadcaster,
      provider,
    };
  }

  it('updates state if the focus ID matches', () => {
    const { broadcaster, provider } = setup();
    (broadcaster.getAreaElement as jest.Mock).mockReturnValue({
      childFocusIndex: 0,
    });

    const { result } = renderHook(() => useAreaChildFocusIndex(), {
      wrapper: provider,
    });
    expect(result.current).toEqual(0);

    (broadcaster.getAreaElement as jest.Mock).mockReturnValue({
      childFocusIndex: 5,
    });
    act(() => {
      (broadcaster.addFocusChangeListener as jest.Mock).mock.calls[0][0]();
    });

    expect(result.current).toEqual(5);

    (broadcaster.getAreaElement as jest.Mock).mockReturnValue({
      childFocusIndex: 3,
    });
    act(() => {
      (broadcaster.addFocusChangeListener as jest.Mock).mock.calls[0][0]();
    });

    expect(result.current).toEqual(3);
  });

  it('does not set state if the listener is invoked while unmounting', () => {
    const { broadcaster, provider } = setup();
    (broadcaster.getAreaElement as jest.Mock).mockReturnValue({
      childFocusIndex: 0,
    });

    const { result, unmount } = renderHook(() => useAreaChildFocusIndex(), {
      wrapper: provider,
    });
    expect(result.current).toEqual(0);

    unmount();

    (broadcaster.getAreaElement as jest.Mock).mockReturnValue({
      childFocusIndex: 10,
    });
    act(() => {
      (broadcaster.addFocusChangeListener as jest.Mock).mock.calls[0][0]();
    });

    expect(result.current).toEqual(0);
  });
});
