interface Focusable {
  focus(): void;
}

type RefHandler = (node: Focusable | null) => void;

/**
 * A handler for imperatively focusing a React element's ref.
 */
export function refFocusHandler(isFocused: boolean): RefHandler {
  return (node: Focusable | null): void => {
    if (node && isFocused) {
      node.focus();
    }
  };
}
