import { refFocusHandler } from '.';

describe(refFocusHandler, () => {
  it('focuses when active', () => {
    const focus = jest.fn();
    const node = { focus } as unknown as HTMLElement;
    const refHandler = refFocusHandler(true);

    refHandler(node);
    expect(focus.mock.calls).toHaveLength(1);
  });

  it('noop when inactive', () => {
    const focus = jest.fn();
    const node = { focus } as unknown as HTMLElement;
    const refHandler = refFocusHandler(false);

    refHandler(node);
    expect(focus.mock.calls).toHaveLength(0);
  });

  it('noop when node is null', () => {
    const refHandler = refFocusHandler(true);

    expect(() => refHandler(null)).not.toThrow();
  });
});
