import type {
  FocusBroadcasterMethods,
  FocusableAreaElement,
} from './NavigationRoot';
import { ROOT_FOCUS_ID, getFocusId } from './NavigationRoot';

export function mockFocusBroadcaster(): FocusBroadcasterMethods & {
  removeChangeListener: () => void;
} {
  const removeChangeListener = jest.fn();

  return {
    addFocusChangeListener: jest.fn().mockReturnValue(removeChangeListener),
    focusElement: jest.fn(),
    getAreaElement: jest.fn(),
    isFocused: jest.fn().mockReturnValue(false),
    registerArea: jest.fn(),
    removeArea: jest.fn(),
    removeChangeListener,
  };
}

export function mockArea(
  overrides: Partial<FocusableAreaElement> & { elementCount: number },
): FocusableAreaElement {
  const focusIndex = overrides.focusIndex ?? 0;
  const parentFocusId = overrides.parentFocusId ?? ROOT_FOCUS_ID;
  const focusId = getFocusId(parentFocusId, focusIndex);

  return {
    childFocusIndex: 0,
    debugLabel: 'mockArea',
    focusId,
    focusIndex,
    handleWheel: false,
    horizontalIncrement: 10,
    instanceId: Math.random().toString(),
    parentFocusId,
    type: 'vertical',
    verticalIncrement: 1,
    ...overrides,
  };
}
