# Pulsar-Analytics

Player agnostic analytics implementation of Twitch video
[metrics](https://docs.google.com/document/d/1W6wX_vN30UvkA8dbbXrydyJUJ0k42FUEalWvDj4Aetc/).

## Supported Events

- Minute Watched
- Video Play
- Buffer Empty
- Buffer Refill
- Video Error
- Video Ended

This package will attach primitive player information, it is up to the consumer
to attach higher level environment, user, and content specific tracking fields.
See `src/events` for the full implementation details.

## Usage

```sh
yarn add pulsar-analytics
```

```ts
import { subscribeVideoAnalytics } from 'pulsar-analytics';

// Calling this will cleanup any listeners that were created
const unSubscribeVideoAnalytics = subscribeVideoAnalytics({
  backend: 'native',
  onTrackingEvent: (playerEvent) => {
    /*...*/
  },
  timeSinceLoadStart: Date.now(),
  video: videoElement,
});
```
