import type { PlayerAnalyticsEvent } from 'pulsar-utils';
import type { SpadeBaseProperties } from './baseProperties';

/**
 * Spade formatted "buffer-empty" event:
 * https://blueprint.di.xarth.tv/#/schema/buffer-empty
 */
type BufferEmptyEvent = SpadeBaseProperties & {
  /**
   * Total number of buffer empties for the play session.
   */
  buffer_empty_count: number;
  /**
   * A UUID used to correlate empties to refills.
   */
  buffer_session_id: string;
};

/**
 * Dynamic Buffer Empty event properties.
 */
type BufferEmptyProperties = SpadeBaseProperties & {
  bufferEmptyCount: number;
  bufferSessionID: string;
};

// istanbul ignore next: trivial
/**
 * Generates a Spade Formatted "buffer-empty" event.
 */
export function bufferEmptyEvent({
  bufferEmptyCount,
  bufferSessionID,
  ...baseProperties
}: BufferEmptyProperties): PlayerAnalyticsEvent {
  const properties: BufferEmptyEvent = {
    ...baseProperties,
    buffer_empty_count: bufferEmptyCount,
    buffer_session_id: bufferSessionID,
  };

  return {
    name: 'buffer-empty',
    properties,
  };
}
