import type { PlayerAnalyticsEvent } from 'pulsar-utils';
import type { SpadeBaseProperties } from './baseProperties';

/**
 * Spade formatted "buffer-refill" event:
 * https://blueprint.di.xarth.tv/#/schema/buffer-refill
 */
type BufferRefillEvent = SpadeBaseProperties & {
  /**
   * Total number of buffer empties for the play session.
   */
  buffer_empty_count: number;
  /**
   * A UUID used to correlate empties to refills.
   */
  buffer_session_id: string;
  /**
   * Total buffering time in seconds since the corresponding buffer-empty event.
   */
  buffering_time: number;
};

/**
 * Dynamic Buffer Refill event properties.
 */
type BufferRefillProperties = SpadeBaseProperties & {
  bufferDurationSeconds: number;
  bufferEmptyCount: number;
  bufferSessionID: string;
};

/**
 * Generates a Spade Formatted "buffer-refill" event.
 */
export function bufferRefillEvent({
  bufferDurationSeconds,
  bufferEmptyCount,
  bufferSessionID,
  ...baseProperties
}: BufferRefillProperties): PlayerAnalyticsEvent {
  const properties: BufferRefillEvent = {
    ...baseProperties,
    buffer_empty_count: bufferEmptyCount,
    buffer_session_id: bufferSessionID,
    buffering_time: bufferDurationSeconds,
  };

  return {
    name: 'buffer-refill',
    properties,
  };
}
