import type { PlayerAnalyticsEvent } from 'pulsar-utils';
import type { SpadeBaseProperties } from './baseProperties';

/**
 * Spade formatted "video_end" event:
 * Refer to the tracking spec for field definitions:
 * https://docs.google.com/document/d/1W6wX_vN30UvkA8dbbXrydyJUJ0k42FUEalWvDj4Aetc/edit#
 *
 */

// istanbul ignore next: trivial
/**
 * Generates a Spade Formatted "video_end" event.
 */
export function videoEndEvent(
  properties: SpadeBaseProperties,
): PlayerAnalyticsEvent {
  return {
    name: 'video_end',
    properties,
  };
}
