import type { PlayerAnalyticsEvent } from 'pulsar-utils';
import type { SpadeBaseProperties } from './baseProperties';

/**
 * Spade formatted "video-play" event:
 * Refer to the tracking spec for field definitions:
 * https://docs.google.com/document/d/1W6wX_vN30UvkA8dbbXrydyJUJ0k42FUEalWvDj4Aetc/edit#
 *
 * We do not send any of the time_since_* and time_to_* since they are Player-Core specific.
 */
type SpadeVideoPlayProperties = SpadeBaseProperties & {
  time_since_load_start: number;
};

type VideoPlayProperties = SpadeBaseProperties & {
  timeSinceLoadStart: number;
};

// istanbul ignore next: trivial
/**
 * Generates a Spade Formatted "video-play" event.
 */
export function videoPlayEvent({
  timeSinceLoadStart,
  ...baseProperties
}: VideoPlayProperties): PlayerAnalyticsEvent {
  const properties: SpadeVideoPlayProperties = {
    ...baseProperties,
    time_since_load_start: timeSinceLoadStart,
  };

  return {
    name: 'video-play',
    properties,
  };
}
