/**
 * Behavior definition (see minute-watched):
 * https://docs.google.com/document/d/1W6wX_vN30UvkA8dbbXrydyJUJ0k42FUEalWvDj4Aetc
 *
 * Returns a number between [0, 59000] representing the delay to use when counting
 * the first minute watched.
 *
 * This creates a more even reporting distribution of partial
 * minutes watched amongst clients.
 *
 * Example:
 * For a 2m40s playback session, 66% of users report 3 minutes watched and 33%
 * report two minutes watched, averaging out to 2m40s.
 */
export function getFirstMinuteWatchedDelayMs(): number {
  return Math.floor(Math.random() * 60) * 1000;
}
