import { getFirstMinuteWatchedDelayMs } from '.';

describe(getFirstMinuteWatchedDelayMs, () => {
  let randomMock: jest.Mock;

  beforeEach(() => {
    Math.random = jest.fn();
    randomMock = Math.random as jest.Mock;
  });

  it('gives at most 59 seconds', () => {
    randomMock.mockReturnValue(0.99999);
    const result = getFirstMinuteWatchedDelayMs();

    expect(result).toEqual(59000);
  });

  it('gives at least 0 seconds', () => {
    randomMock.mockReturnValue(0);
    const result = getFirstMinuteWatchedDelayMs();

    expect(result).toEqual(0);
  });
});
