import Hls from 'hls.js';

type HlsjsParams = {
  autoPlay?: boolean | undefined;
  video: HTMLVideoElement;
};

export type Hlsjs = {
  hlsjsPlayer: Hls;
  setSrc: (src: string | null, startFromTime?: number) => void;
};

// istanbul ignore next: high cost of mocks, low value tests
export function createHlsjsManager({ autoPlay, video }: HlsjsParams): Hlsjs {
  const hlsjsPlayer = new Hls();

  // The video element remains stable for the life of this HLS instance
  // even across src changes
  const canLoadSrc = new Promise((resolve) => {
    // setup the listener, then attach to avoid a race condition
    hlsjsPlayer.once(Hls.Events.MEDIA_ATTACHED, resolve);
    hlsjsPlayer.attachMedia(video);
  });

  const setSrc = (src: string | null, startFromTime?: number) => {
    if (src === null) {
      return;
    }

    if (!src && video.src) {
      video.pause();
    }

    canLoadSrc.then(() => {
      hlsjsPlayer.loadSource(src);
      video.currentTime = startFromTime ?? 0;
      if (autoPlay) {
        video.play();
      }
    });
  };

  return { hlsjsPlayer, setSrc };
}
