import EventEmitter from 'eventemitter3';
import {
  createNativeEventListenerManager,
  createNativePlaybackManager,
  createNativeQualityManager,
  createPlaybackStateWatcher,
} from 'pulsar-player-controller';
import type {
  CreatePlayerController,
  PlayerControllerEvent,
} from 'pulsar-player-controller';

export function createNativePlayerController(
  video: HTMLVideoElement,
): CreatePlayerController {
  const eventEmitter = new EventEmitter<PlayerControllerEvent>();

  const { subscribeEventListener } = createNativeEventListenerManager(
    video,
    eventEmitter,
  );

  const [getPlaybackState, tearDown] = createPlaybackStateWatcher(
    video,
    eventEmitter,
  );

  const controller = {
    ...createNativePlaybackManager(video),
    ...createNativeQualityManager(video),
    getPlaybackState,
    subscribeEventListener,
  };

  return {
    controller,
    // Preserves the binding of "emit" to "eventEmitter"
    emitEvent: (...args) => eventEmitter.emit(...args),
    tearDown,
  };
}
