import type { FC } from 'react';
import type { UseCaptionManagerProps } from './useCaptionManager';
import { closedCaptionsContext, useCaptionManager } from './useCaptionManager';

export { useClosedCaptions } from './useCaptionManager';

type ClosedCaptionsRootProps = UseCaptionManagerProps;

// istanbul ignore next: trivial
/**
 * Provides Closed Caption support and all necessary logic to toggle / subscribe
 * to caption updates.
 *
 * To toggle or consume captions, utilize `useClosedCaptions`.
 */
export const ClosedCaptionsRoot: FC<ClosedCaptionsRootProps> = ({
  children,
  ...props
}) => {
  const context = useCaptionManager(props);
  return <closedCaptionsContext.Provider children={children} value={context} />;
};

ClosedCaptionsRoot.displayName = 'ClosedCaptionsRoot';
