export type Cue = {
  /** The time when the cue should be cleared. */
  endTime: number;
  /** The time when the cue should be displayed. */
  startTime: number;
  type: 'AdCue' | 'StreamSourceCue' | 'TextCue' | 'TextMetadataCue';
};

export type StreamSourceCue = Cue & {
  /** Stream source type, eg. "live" */
  streamSource: string;
};

/**
 * Contains information for the display of subtitles and captions including styling and positioning.
 * TextCues should be rendered in accordance with user preferences for captions/subtitles and should
 * be cleared/reset when switching streams in the player or after a preset timeout period.
 */
export type TextCue = Cue & {
  /** The line on which the text belongs. */
  line: number;
  /** The position of the text as a fraction of the cue box within the video. */
  position: number;
  /** The size of the cue as a percentage of the video. */
  size: number;
  /** The text of the cue. */
  text: string;
};

/**
 * Contains ad metadata from the stream.
 */
export type AdCue = Cue & {
  /** Ad Format */
  adFormat: string;
  /** Ad Session ID */
  adSessionId: string;
  /** Link to ad click through */
  adUrl: string;
  /** Advertiser ID */
  advertiserID: string;
  /** Ad click tracking url */
  clickTrackingUrl: string;
  /** Creative ID */
  creativeID: string;
  /** Duration of the ad */
  duration: number;
  /** Line item ID */
  lineItemID: string;
  /** Order ID */
  orderID: string;
  /** Number of ads that will be playing */
  podCount: number;
  /** Current ad index */
  podPosition: number;
  /** Type of ad */
  rollType: 'midroll' | 'postroll' | 'preroll';
  /** Tracking complete url */
  trackingUrlComplete: string;
  /** Tracking start url */
  trackingUrlStart: string;
  /** Viewer Level Midroll */
  vlm: boolean;
};
