import type { PlayerAnalyticsEvent } from 'pulsar-utils';
import type { AdCue, StreamSourceCue, TextCue } from './cue';
import type { PlayerError } from './playerError';

export type ControllerEventMap = {
  adCue: AdCue;
  analytics: PlayerAnalyticsEvent;
  audioBlocked: void;
  error: PlayerError;
  playbackBlocked: void;
  playbackStateChange: void;
  playing: void;
  qualityChange: void;
  streamSourceCue: StreamSourceCue;
  textCue: TextCue;
  timeUpdate: void;
  volume: void;
};

export type PlayerEventHandler<K extends keyof ControllerEventMap> = (
  payload: ControllerEventMap[K],
) => void;
