export type PlaybackState =
  /**
   * Indicates that the Player is buffering content and playback stopped.
   */
  | 'Buffering'
  /**
   * Indicates that the Player reached the end of a video or a live stream ends.
   */
  | 'Ended'
  /**
   * Indicates that the Player is idle or paused.
   */
  | 'Idle'
  /**
   * Indicates that the Player is initializing and not yet ready to play. This is the initial state.
   */
  | 'Initializing'
  /**
   * Indicates that the Player is playing.
   */
  | 'Playing'
  /**
   * Indicates that the Player is ready to play the loaded video or live stream.
   */
  | 'Ready';
