export enum ErrorType {
  /** A network resource is not authorized. */
  AUTHORIZATION = 'ErrorAuthorization',
  /** A generic error occurred. */
  GENERIC = 'Error',
  /** Data or input is invalid. */
  INVALID_DATA = 'ErrorInvalidData',
  /** A method parameter is invalid. */
  INVALID_PARAMETER = 'ErrorInvalidParameter',
  /** The player or an internal object is in an invalid state. */
  INVALID_STATE = 'ErrorInvalidState',
  /** There is a network error. */
  NETWORK = 'ErrorNetwork',
  /** There is a network I/O failure. */
  NETWORK_IO = 'ErrorNetworkIO',
  /**
   * The stream is not available. The accompanying HTTP status code can help identify why the stream is unavailable.
   * If the status code is 429, the concurrent-viewers limit was reached. If the status code is 404, the stream
   * does not exist or is offline.
   */
  NOT_AVAILABLE = 'ErrorNotAvailable',
  /** A method or feature is not supported. */
  NOT_SUPPORTED = 'ErrorNotSupported',
  /** There is no source for the player to play. */
  NO_SOURCE = 'ErrorNoSource',
  /** The player timed out on an operation. */
  TIMEOUT = 'ErrorTimeout',
}

export enum AuthorizationError {
  /** Premium content is not available in your region. */
  GEOBLOCKED = 1,
  /** This device does not support playback of premium content. */
  UNSUPPORTED_DEVICE = 2,
  /** A proxy or unblocker has been detected. */
  ANONYMIZER_BLOCKED = 3,
  /** A wi-fi network is required to watch premium content. */
  CELLULAR_NETWORK_PROHIBITED = 4,
  /** This premium content is restricted. */
  UNAUTHORIZATION_ENTITLEMENTS = 5,
  /** This VOD is restricted. */
  VOD_RESTRICTED = 6,
}

export type PlayerError = {
  /**
   * A code representing the specific error condition. The code values depend on the
   * source and result types. For example, if source is "Segment", the result is
   * [[ErrorType.NETWORK]], and the code value is 400, this indicates that an HTTP 400
   * error occurred while trying to download a video segment.
   */
  code: number;
  /** A message describing the error. */
  message: string;
  /** The source component within the player that generated the error. */
  source: string;
  /** The result code for the error. */
  type: ErrorType;
};
