import type { PlaybackManager } from '../../controller-types';

// istanbul ignore next: trivial
export function createNativePlaybackManager(
  video: HTMLVideoElement,
): PlaybackManager {
  return {
    getDuration: () => video.duration,
    getPosition: () => video.currentTime,
    getVolume: () => video.volume,
    isMuted: () => video.muted,
    isPaused: () => video.paused,
    pause: () => video.pause(),
    play: () => video.play(),
    restart: () => {
      video.currentTime = 0;
      video.play();
    },
    seekTo: (position: number) => {
      video.currentTime = position;
    },
    setMuted: (muted: boolean) => {
      video.muted = muted;
    },
    setVolume: (newVolume: number) => {
      video.volume = newVolume;
    },
  };
}
