import type { QualityManager } from '../../controller-types';

// istanbul ignore next: trivial
export function createNativeQualityManager(
  video: HTMLVideoElement,
): QualityManager {
  function getQuality() {
    return {
      bitrate: 0,
      codecs: 'unknown',
      framerate: 0,
      group: 'unknown',
      height: video.videoHeight,
      isDefault: true,
      name: 'auto',
      width: video.videoWidth,
    };
  }
  return {
    /**
     * No-op. Not supported for Native HLS playback.
     */
    getQualities: () => [getQuality()],
    /**
     * No-op. Not supported for Native HLS playback.
     */
    getQuality,
    /**
     * Always true for native HLS playback.
     */
    isAutoQualityMode: () => true,
    /**
     * No-op. Not supported for Native HLS playback.
     */
    setAutoQualityMode: () => undefined,
    /**
     * No-op. Not supported for Native HLS playback.
     */
    setQuality: () => undefined,
  };
}
