import { useMemo } from 'react';
import { useSubscription } from 'use-subscription';
import { usePlayerController } from '../PlayerControllerRoot';
import type { PlaybackState } from '../controller-types';

/**
 * Returns the playback state for the player.
 */
export function usePlaybackState(): PlaybackState {
  // Each hook registers time update events directly on MediaPlayer rather than
  // using a context to avoid all of the child re-renders from constant
  // provider state updates
  const playerController = usePlayerController();

  // Memoize to avoid removing and re-adding subscriptions each time this hook is called.
  const subscription = useMemo(
    () => ({
      getCurrentValue: () =>
        playerController?.getPlaybackState() ?? 'Initializing',
      subscribe: (notifier: () => void) => {
        return (
          playerController?.subscribeEventListener(
            'playbackStateChange',
            notifier,
          ) ?? (() => undefined)
        );
      },
    }),
    [playerController],
  );

  return useSubscription(subscription);
}
