import { act, renderHook } from '@testing-library/react-hooks';
import { usePlayerController } from '../PlayerControllerRoot';
import type { MockPlayerController } from '../test-mocks';
import { mockPlayerController } from '../test-mocks';
import { usePlaybackState } from '.';

jest.mock('../PlayerControllerRoot', () => ({
  usePlayerController: jest.fn(),
}));

const mockUsePlayerController = usePlayerController as jest.Mock;

describe(usePlaybackState, () => {
  let mockedPlayerController: MockPlayerController;

  beforeEach(() => {
    mockedPlayerController = mockPlayerController({
      getPlaybackState: jest.fn(() => 'Initializing'),
    });
    mockUsePlayerController.mockReturnValue(mockedPlayerController);
  });

  it('returns 0 if media player is not yet available', () => {
    mockUsePlayerController.mockReturnValue(null);
    const { result } = renderHook(() => usePlaybackState());
    expect(result.current).toEqual('Initializing');
  });

  it('returns the current value from media player if already available / playing', () => {
    (mockedPlayerController.getPlaybackState as jest.Mock).mockReturnValue(
      'Buffering',
    );
    const { result } = renderHook(() => usePlaybackState());
    expect(result.current).toEqual('Buffering');
  });

  it('updates the current value when a state change occurs', () => {
    const { result } = renderHook(() => usePlaybackState());
    expect(result.current).toEqual('Initializing');

    (mockedPlayerController.getPlaybackState as jest.Mock).mockReturnValue(
      'Ended',
    );
    act(() => {
      mockedPlayerController.emitEvent('playbackStateChange');
    });

    expect(result.current).toEqual('Ended');
  });
});
