import { act, renderHook } from '@testing-library/react-hooks';
import { usePlayerController } from '../PlayerControllerRoot';
import type { MockPlayerController } from '../test-mocks';
import { mockPlayerController } from '../test-mocks';
import { usePlaybackTime } from '.';

jest.mock('../PlayerControllerRoot', () => ({
  usePlayerController: jest.fn(),
}));

const mockUsePlayerController = usePlayerController as jest.Mock;

describe(usePlaybackTime, () => {
  let mockedPlayerController: MockPlayerController;

  beforeEach(() => {
    mockedPlayerController = mockPlayerController({ getPosition: jest.fn() });
    mockUsePlayerController.mockReturnValue(mockedPlayerController);
  });

  it('returns 0 if media player is not yet available', () => {
    mockUsePlayerController.mockReturnValue(null);
    const { result } = renderHook(() => usePlaybackTime());
    expect(result.current).toEqual(0);
  });

  it('returns the current value from media player if already available / playing', () => {
    (mockedPlayerController.getPosition as jest.Mock).mockReturnValue(30.5);
    const { result } = renderHook(() => usePlaybackTime());
    expect(result.current).toEqual(30);
  });

  it('updates the current value when a media player time update occurs', () => {
    const { result } = renderHook(() => usePlaybackTime());
    expect(result.current).toEqual(0);

    (mockedPlayerController.getPosition as jest.Mock).mockReturnValue(20);
    act(() => {
      mockedPlayerController.emitEvent('timeUpdate');
    });
    expect(result.current).toEqual(20);
  });
});
