import { useEffect, useState } from 'react';
import { usePlayerController } from '../PlayerControllerRoot';
import type { PlayerError } from '../controller-types';

// istanbul ignore next: trivial
export function usePlayerError(): PlayerError | null {
  const [error, setError] = useState<PlayerError | null>(null);
  const playerController = usePlayerController();

  useEffect(
    () => playerController?.subscribeEventListener('error', setError),
    [playerController],
  );

  return error;
}
