import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import { usePlayerController } from '../PlayerControllerRoot';
import type { PlayerController } from '../controller-types';

export type PlayerControllerProps = {
  playerController: PlayerController | null;
};

// istanbul ignore next: trivial
export function withPlayerController<P extends PlayerControllerProps>(
  Comp: ComponentType<P>,
): ComponentType<Omit<P, keyof PlayerControllerProps>> {
  const WithPlayerControllerComponent: FC<
    Omit<P, keyof PlayerControllerProps>
  > = (props) => {
    const playerController = usePlayerController();

    const mergedProps = {
      ...props,
      playerController,
    } as P;

    return <Comp {...mergedProps} />;
  };

  WithPlayerControllerComponent.displayName = `WithPlayerController(${getComponentName(
    Comp,
  )})`;

  return WithPlayerControllerComponent;
}
