# Pulsar-Player-Core

A UI agnostic, React API for consuming
[Player-Core](https://git.xarth.tv/video/player-core).

## Features

- Stream, VOD, and Clip playback support
- Emits fully hydrated Player
  [tracking events](https://docs.google.com/document/d/1W6wX_vN30UvkA8dbbXrydyJUJ0k42FUEalWvDj4Aetc/edit)
  emission
- Imperative Player Control Via React Context / Hooks

See the working [example](../../../package-examples/pulsar-core/README.md).

## Usage

```tsx
import type { FC } from 'react';
import { PulsarCore, PulsarCorePreloadWASM, VideoType } from 'pulsar-player-core';

const PlayerConsumer: FC = () => (
  <>
    <head>
      <PulsarCorePreloadWASM />
    </head>
    <body>
      <PulsarCore
        autoPlay={true}
        environment={{...}}
        onContentRestriction={(restriction) => {/*...*/}}
        onTrackingEvent={(event) => {/*...*/}}
        onError={(error) => {/*...*/}}
        params={{...}}
      />
    </body>
  </>
);
```

## Advanced Interactions

Pulsar-Core integrates with the
[PlayerController](../../pulsar/player-controller/README.md) API.

## Debugging

If you pass `debugMode=true` in the props to `PulsarCore`, it will:

- enable debug-level logging from player-core
- attach `mediaPlayerInstance` to `window`

These can be very helpful in looking more deeply into playback issues.

## Building Against Player-Core Locally

1. Install Yalc: `yarn global add yalc`
1. Follow the Player-Core
   [setup instructions](https://git.xarth.tv/video/player-core/blob/master/platforms/web/README.md)
1. In Player-Core run `npm run build:prod && yalc push`
1. In this package run `yalc add player-core`
1. Run `npm run build:prod && yalc push` as necessary with each change.
1. Finally, run `yalc remove player-core` when finished.

## Updating Player-Core Versions

Follow this [guide](../../../processes/upgrading-player-core.md).
