import type { FC } from 'react';
import {
  DEFAULT_ASM_WORKER_URL,
  DEFAULT_WASM_WORKER_URL,
} from '../createMediaPlayer';

export const PulsarCorePreloadASMJS: FC = () => (
  <link as="script" href={DEFAULT_ASM_WORKER_URL} rel="preload" />
);

PulsarCorePreloadASMJS.displayName = 'PlayerCorePreloadASMJS';

// Only the JS worker can be preloaded, not the binary, see:
// https://git.xarth.tv/mobile-web/tachyon/pull/2508#discussion_r498051
export const PulsarCorePreloadWASM: FC = () => (
  <link as="script" href={DEFAULT_WASM_WORKER_URL} rel="preload" />
);

PulsarCorePreloadWASM.displayName = 'PlayerCorePreloadWASM';
