import { lorem } from 'faker';
import {
  mockClipParams,
  mockStreamParams,
  mockVideoParams,
} from '../../../test-mocks';
import { createSrcUrl } from '.';

describe(createSrcUrl, () => {
  it('formats a stream source', () => {
    const params = mockStreamParams();
    params.owner.login = 'therealderekt';
    expect(createSrcUrl({ params })).toEqual('https://twitch.tv/therealderekt');
  });

  it('formats a VOD source', () => {
    const params = mockVideoParams();
    params.video.id = '12345';
    expect(createSrcUrl({ params })).toEqual('https://twitch.tv/v/12345');
  });

  it('formats a Clip source', () => {
    const params = mockClipParams();
    params.clip.slug = lorem.sentence(5);
    expect(createSrcUrl({ params })).toEqual(
      `https://clips.twitch.tv/${params.clip.slug}`,
    );
  });

  it('returns a main manifest URL if set in params', () => {
    const params = mockStreamParams();
    const src = 'https://some.manifest.url.com';
    expect(createSrcUrl({ params, src })).toEqual(src);
  });

  it('returns a stream URL if mainManifestUrl is set but undefined', () => {
    const params = mockStreamParams();
    params.owner.login = 'therealderekt';
    expect(createSrcUrl({ params, src: undefined })).toEqual(
      'https://twitch.tv/therealderekt',
    );
  });
});
