import { AuthorizationError } from 'player-core';
import { ContentRestriction } from '../../params';

/**
 * For errors of type ErrorType.AUTHORIZATION, used to map the code to an enum
 * value.
 */
export function errorCodeToContentRestriction(
  code: AuthorizationError,
): ContentRestriction {
  switch (code) {
    case AuthorizationError.GEOBLOCKED:
      return ContentRestriction.GeoBlocked;
    case AuthorizationError.UNAUTHORIZATION_ENTITLEMENTS:
      return ContentRestriction.PremiumContent;
    case AuthorizationError.ANONYMIZER_BLOCKED:
    case AuthorizationError.CELLULAR_NETWORK_PROHIBITED:
    case AuthorizationError.UNSUPPORTED_DEVICE:
    case AuthorizationError.VOD_RESTRICTED:
      return ContentRestriction.Unknown;
    default:
      const _exhaustive: never = code;
      return _exhaustive;
  }
}
