import { AuthorizationError } from 'player-core';
import { ContentRestriction } from '../../params';
import { errorCodeToContentRestriction } from '.';

interface TestData {
  authCode: number;
  expected: AuthorizationError;
}

describe(errorCodeToContentRestriction, () => {
  it.each`
    authCode                                           | expected
    ${AuthorizationError.GEOBLOCKED}                   | ${ContentRestriction.GeoBlocked}
    ${AuthorizationError.UNAUTHORIZATION_ENTITLEMENTS} | ${ContentRestriction.PremiumContent}
    ${AuthorizationError.ANONYMIZER_BLOCKED}           | ${ContentRestriction.Unknown}
    ${AuthorizationError.CELLULAR_NETWORK_PROHIBITED}  | ${ContentRestriction.Unknown}
    ${AuthorizationError.UNSUPPORTED_DEVICE}           | ${ContentRestriction.Unknown}
    ${AuthorizationError.VOD_RESTRICTED}               | ${ContentRestriction.Unknown}
  `('returns $expected for $authCode', ({ authCode, expected }: TestData) => {
    expect(errorCodeToContentRestriction(authCode)).toEqual(expected);
  });
});
