import { uniqueIDGenerator } from 'tachyon-utils-twitch';
import type {
  BasePulsarCoreProps,
  ClipParams,
  PulsarCoreClipProps,
  PulsarCoreStreamProps,
  PulsarCoreVideoProps,
  StreamParams,
  VideoParams,
} from './PlayerCore';
import { VideoType } from './types';

// istanbul ignore file: mocks

export function mockClipParams(overrides?: Partial<ClipParams>): ClipParams {
  return {
    clip: {
      id: uniqueIDGenerator(),
      slug: uniqueIDGenerator(),
    },
    type: VideoType.Clip,
    ...overrides,
  };
}

export function mockStreamParams(
  overrides?: Partial<StreamParams>,
): StreamParams {
  const broadcasterLogin = 'therealderekt';

  return {
    owner: {
      login: broadcasterLogin,
    },
    type: VideoType.Stream,
    ...overrides,
  };
}

export function mockVideoParams(overrides?: Partial<VideoParams>): VideoParams {
  return {
    type: VideoType.Video,
    video: {
      id: uniqueIDGenerator(),
    },
    ...overrides,
  };
}

function mockBasePlayerProps(): BasePulsarCoreProps {
  return {
    autoPlay: true,
    environment: {
      benchmarkSessionID: uniqueIDGenerator(),
      clientAPIID: uniqueIDGenerator(),
      clientApp: 'tachyon',
      clientBuildID: uniqueIDGenerator(),
      deviceID: uniqueIDGenerator(),
      platform: 'mobile_web',
    },
    onFirstControlsAppear: () => undefined,
  };
}

export function mockClipProps(
  overrides?: Partial<PulsarCoreClipProps>,
): PulsarCoreClipProps {
  return {
    ...mockBasePlayerProps(),
    params: mockClipParams(),
    ...overrides,
  };
}

export function mockVideoProps(
  overrides?: Partial<PulsarCoreVideoProps>,
): PulsarCoreVideoProps {
  return {
    ...mockBasePlayerProps(),
    params: mockVideoParams(),
    ...overrides,
  };
}

export function mockStreamProps(
  overrides?: Partial<PulsarCoreStreamProps>,
): PulsarCoreStreamProps {
  return {
    ...mockBasePlayerProps(),
    params: mockStreamParams(),
    ...overrides,
  };
}
