import type {
  PlayerController,
  QualitySettings,
} from 'pulsar-player-controller';

export enum VideoType {
  Clip = 'Clip',
  Stream = 'Stream',
  Video = 'Video',
}

export type PulsarCoreQuality = {
  /** The codec string, both audio and video tracks. For example, "avc1.64002A,mp4a.40.2". */
  codecs: string;
  /**
   * The group to which the track belongs to. Specified by the optional GROUP-ID attribute in the main HLS playlist.
   */
  group: string;
  /**
   * A string indicating the media selection should be played if the user hasn't selected another option.
   * Specified by the optional DEFAULT attribute in the main HLS playlist.
   */
  isDefault: boolean;
  /** The name of the quality object. */
  name: string;
};

export type PulsarCorePlayerController = PlayerController<PulsarCoreQuality>;

export type PulsarCoreQualitySettings = QualitySettings<PulsarCoreQuality>;
